/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWCallStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.VWSystemStepPropPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWRouteListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWStepRoutingPanel
extends VWStepPropTabPanel
implements ListSelectionListener {
    private VWMapNode m_mapNode = null;
    private VWRouteDefinition[] m_routes = null;
    private boolean m_bResponses = true;
    private JList m_routeList = null;
    private DefaultListModel m_routeListModel = new DefaultListModel();
    private JLabel m_outGoingInfo = new JLabel();
    private JTextArea m_expressionArea = null;
    private JPanel m_evaluationPanel = null;
    private String[] m_possibleResponses = null;
    private JList m_possibleResponsesUI = null;
    private DefaultListModel m_possibleResponsesModel = new DefaultListModel();
    private boolean m_bCollectorStep = false;
    private JCheckBox m_collectorCheckBox = new JCheckBox(VWResource.s_collectorStep);

    public VWStepRoutingPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        if (propPanel instanceof VWCallStepPropPanel || propPanel instanceof VWSystemStepPropPanel) {
            this.m_bResponses = false;
        }
        this.m_type = 6;
        this.preSetupLayout();
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        try {
            if (this.m_step != null) {
                this.m_mapNode = this.m_step.getMapNode();
                this.m_possibleResponses = this.m_mapNode instanceof VWStepDefinition && this.m_bResponses ? ((VWStepDefinition)this.m_mapNode).getResponses() : null;
                this.m_routes = this.m_mapNode.getNextRoutes();
                this.m_bCollectorStep = this.m_mapNode.getJoinType() == 1;
            } else {
                this.m_mapNode = null;
                this.m_possibleResponses = null;
                this.m_routes = null;
                this.m_bCollectorStep = false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    protected void preSetupLayout() {
        JPanel responsePanel = new JPanel();
        JPanel incomingPanel = new JPanel();
        JPanel outgoingPanel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(0, 4, 0, 4);
        Insets nullInsets = new Insets(0, 0, 0, 0);
        VWToolbarBorder responseBorder = null;
        JScrollPane scrollPane = null;
        if (this.m_bResponses) {
            responseBorder = new VWToolbarBorder(VWResource.s_responses, 0);
            responsePanel = responseBorder.getClientPanel();
            responsePanel.setLayout(new BorderLayout());
            this.m_possibleResponsesUI = new JList();
            scrollPane = new JScrollPane(this.m_possibleResponsesUI);
            scrollPane.setPreferredSize(new Dimension(10, 50));
        }
        VWToolbarBorder incomingBorder = new VWToolbarBorder(VWResource.s_IncomingRoutingInfo, 0);
        incomingPanel = incomingBorder.getClientPanel();
        incomingPanel.setLayout(new BorderLayout(0, 0));
        incomingPanel.add((Component)this.m_collectorCheckBox, "Last");
        this.m_collectorCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                VWStepRoutingPanel.this.m_collectorCheckBox.setSelected(VWStepRoutingPanel.this.m_bCollectorStep);
            }
        });
        VWToolbarBorder outgoingBorder = new VWToolbarBorder(VWResource.s_outgoingRouting, 0);
        outgoingPanel = outgoingBorder.getClientPanel();
        outgoingPanel.setLayout(new BorderLayout());
        outgoingPanel.add((Component)this.m_outGoingInfo, "First");
        this.setLayout(new GridBagLayout());
        c.anchor = 23;
        if (this.m_bResponses) {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.anchor = 23;
            c.insets = insets;
            this.add((Component)responseBorder, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 3;
            c.weightx = 0.0;
            c.weighty = 0.3;
            c.insets = nullInsets;
            this.add(Box.createVerticalStrut(300), c);
            c.gridx = 1;
            c.weighty = 0.0;
            this.add(Box.createVerticalStrut(150), c);
            c.gridx = 2;
            c.gridwidth = 0;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = insets;
            this.add((Component)scrollPane, c);
            ++c.gridy;
        } else {
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 1;
            c.gridwidth = 0;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = insets;
        }
        this.add((Component)incomingBorder, c);
        ++c.gridy;
        this.add((Component)outgoingBorder, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 0.3;
        c.insets = nullInsets;
        this.add(Box.createVerticalStrut(300), c);
        c.gridx = 1;
        c.weighty = 0.0;
        this.add(Box.createVerticalStrut(60), c);
        c.gridx = 2;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = insets;
        if (this.m_routeList == null) {
            this.m_routeList = new JList(this.m_routeListModel);
            this.m_routeList.setCellRenderer(new VWRouteListCellRenderer());
            this.m_routeList.addListSelectionListener(this);
            this.m_routeList.setSelectionMode(1);
        }
        this.add((Component)new JScrollPane(this.m_routeList), c);
        c.gridx = 2;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_expression)), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 0.7;
        c.insets = nullInsets;
        this.add(Box.createVerticalStrut(700), c);
        c.gridx = 1;
        c.weighty = 0.0;
        this.add(Box.createVerticalStrut(140), c);
        c.gridx = 2;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = insets;
        this.m_expressionArea = new JTextArea();
        this.m_expressionArea.setEditable(false);
        this.add((Component)new JScrollPane(this.m_expressionArea), c);
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
    }

    protected void setupLayout() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        if (this.m_mapNode != null) {
            switch (this.m_mapNode.getSplitType()) {
                case 1: {
                    this.m_outGoingInfo.setText(VWResource.s_routeAllTrue);
                    break;
                }
                case 2: {
                    this.m_outGoingInfo.setText(VWResource.s_routeFirstTrue);
                    break;
                }
                default: {
                    this.m_outGoingInfo.setText(VWResource.s_noOutGoingRoutingInformation);
                }
            }
        }
        this.m_collectorCheckBox.setSelected(this.m_bCollectorStep);
        if (this.m_mapNode instanceof VWStepDefinition && this.m_bResponses) {
            this.initResponseModel();
            this.m_possibleResponsesUI.setModel(this.m_possibleResponsesModel);
        }
        this.m_routeListModel.removeAllElements();
        if (this.m_routes != null) {
            for (int i = 0; i < this.m_routes.length; ++i) {
                VWRouteDefinition route = this.m_routes[i];
                if (route == null) continue;
                this.m_routeListModel.addElement(route);
            }
            if (this.m_routeList != null) {
                this.m_routeList.setSelectedIndex(-1);
            }
        }
        this.updateExpressionArea();
        this.updateUI();
    }

    private void updateExpressionArea() {
        if (this.m_expressionArea != null) {
            this.m_expressionArea.setText("");
        }
        if (this.m_routeList == null) {
            return;
        }
        Object obj = this.m_routeList.getSelectedValue();
        if (obj == null || !(obj instanceof VWRouteDefinition)) {
            return;
        }
        VWRouteDefinition route = (VWRouteDefinition)obj;
        try {
            String routeCondition = route.getCondition();
            if (routeCondition == null) {
                routeCondition = VWResource.s_true;
            }
            String text = route.getDestinationStep().getName();
            text = text + "\n   ";
            text = text + routeCondition;
            if (this.m_expressionArea != null) {
                this.m_expressionArea.setText(text);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateExpressionArea();
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_expressionArea == null) {
            return;
        }
        Font aFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null && (aFont = new Font(font.getName(), font.getStyle(), font.getSize())) != null) {
            this.m_expressionArea.setFont(aFont);
        }
    }

    private void initResponseModel() {
        if (!this.m_bResponses) {
            return;
        }
        this.m_possibleResponsesModel.removeAllElements();
        if (this.m_possibleResponses != null && this.m_possibleResponses.length > 0) {
            for (int index = 0; index < this.m_possibleResponses.length; ++index) {
                this.m_possibleResponsesModel.addElement(this.m_possibleResponses[index]);
            }
        }
    }

    public void removeReferences() {
        int i;
        super.removeReferences();
        this.m_mapNode = null;
        if (this.m_routes != null) {
            for (i = 0; i < this.m_routes.length; ++i) {
                this.m_routes[i] = null;
            }
            this.m_routes = null;
        }
        this.m_routeList = null;
        this.m_routeListModel = null;
        this.m_outGoingInfo = null;
        this.m_expressionArea = null;
        this.m_evaluationPanel = null;
        if (this.m_possibleResponses != null) {
            for (i = 0; i < this.m_possibleResponses.length; ++i) {
                this.m_possibleResponses[i] = null;
            }
        }
        this.m_possibleResponsesUI = null;
        this.m_possibleResponsesModel = null;
        this.m_collectorCheckBox = null;
        this.removeAll();
    }
}

